/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.apple2e.MOS65C02;
import jace.core.Computer;
import jace.core.RAM;
import jace.hardware.massStorage.CardMassStorage;
import jace.hardware.massStorage.IDisk;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LargeDisk
implements IDisk {
    RandomAccessFile diskImage;
    File diskPath;
    private int dataOffset = 0;
    private int physicalBlocks = 0;
    private int logicalBlocks = 0;

    public LargeDisk(File f) {
        try {
            this.readDiskImage(f);
        }
        catch (IOException ex) {
            Logger.getLogger(LargeDisk.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void mliFormat() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mliRead(int block, int bufferAddress) throws IOException {
        RAM memory = Computer.getComputer().getMemory();
        if (block < this.physicalBlocks) {
            this.diskImage.seek(block * 512 + this.dataOffset);
            for (int i = 0; i < 512; ++i) {
                memory.write(bufferAddress + i, this.diskImage.readByte(), true);
            }
        } else {
            for (int i = 0; i < 512; ++i) {
                memory.write(bufferAddress + i, (byte)0, true);
            }
        }
    }

    @Override
    public void mliWrite(int block, int bufferAddress) throws IOException {
        if (block < this.physicalBlocks) {
            RAM memory = Computer.getComputer().getMemory();
            this.diskImage.seek(block * 512 + this.dataOffset);
            byte[] buf = new byte[512];
            for (int i = 0; i < 512; ++i) {
                buf[i] = memory.read(bufferAddress + i, false);
            }
            this.diskImage.write(buf);
        }
    }

    @Override
    public void boot0(int slot) throws IOException {
        Computer.getComputer().getCpu().suspend();
        this.mliRead(0, 2048);
        byte slot16 = (byte)(slot << 4);
        ((MOS65C02)Computer.getComputer().getCpu()).X = slot16;
        RAM memory = Computer.getComputer().getMemory();
        memory.write(CardMassStorage.SLT16, slot16, false);
        memory.write(CardMassStorage.MLI_COMMAND, (byte)CardMassStorage.MLI_COMMAND_TYPE.READ.intValue, false);
        memory.write(CardMassStorage.MLI_UNITNUMBER, slot16, false);
        memory.writeWord(72, 49152 + CardMassStorage.DEVICE_DRIVER_OFFSET + slot * 256, false);
        ((MOS65C02)Computer.getComputer().getCpu()).setProgramCounter(2048);
        Computer.getComputer().getCpu().resume();
    }

    @Override
    public File getPhysicalPath() {
        return this.diskPath;
    }

    @Override
    public void setPhysicalPath(File f) throws IOException {
        this.diskPath = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read2mg(File f) {
        boolean result = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getPhysicalPath());
            if (fis.read() == 50 && fis.read() == 73 && fis.read() == 77 && fis.read() == 71) {
                System.out.println("Disk is 2MG");
                this.dataOffset = 64;
                this.logicalBlocks = this.physicalBlocks = (int)(f.length() / 512L);
                result = true;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LargeDisk.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(LargeDisk.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(LargeDisk.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public void readHdv(File f) {
        System.out.println("Disk is HDV");
        this.dataOffset = 0;
        this.logicalBlocks = this.physicalBlocks = (int)(f.length() / 512L);
    }

    private void readDiskImage(File f) throws FileNotFoundException, IOException {
        this.eject();
        this.setPhysicalPath(f);
        if (!this.read2mg(f)) {
            this.readHdv(f);
        }
        this.diskImage = new RandomAccessFile(f, "rwd");
    }

    @Override
    public void eject() {
        if (this.diskImage != null) {
            try {
                this.diskImage.close();
                this.diskImage = null;
                this.setPhysicalPath(null);
            }
            catch (IOException ex) {
                Logger.getLogger(LargeDisk.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public boolean isWriteProtected() {
        return this.diskPath == null || !this.diskPath.canWrite();
    }

    @Override
    public int getSize() {
        return this.physicalBlocks;
    }
}

